<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\ModuloFormativo;
use App\Models\PlanEstudio;

class ModuloFormativoController extends Controller
{
    public function index(Request $request)
{
    // Inicializamos la consulta base
    $modulos = ModuloFormativo::with('planEstudio');

    // Filtrado por Plan de Estudio
    if ($request->has('plan_estudio_id') && $request->plan_estudio_id) {
        $modulos->where('id_plan_estudio', $request->plan_estudio_id);
    }

    // Ejecutar la consulta y obtener los módulos
    $modulos = $modulos->get();

    // Obtener Planes de Estudio para los filtros
    $planesEstudio = PlanEstudio::all();

    // Retornar vista con datos
    return view('modulo_formativos.index', compact('modulos', 'planesEstudio'));
}


    public function create()
    {
        $planesEstudio = PlanEstudio::all();
        return view('modulo_formativos.create', compact('planesEstudio'));
    }

    public function store(Request $request)
{
    // Validar los datos
    $request->validate([
        'id_plan_estudio' => 'required|exists:planes_estudio,id',
        'nombre' => 'required|string|max:100',
        'num_modulo' => 'required|integer',
        'horas' => 'required|integer|min:0',
        'creditos' => 'required|integer|min:0',
    ]);

    try {
        // Crear el nuevo módulo formativo
        ModuloFormativo::create([
            'id_plan_estudio' => $request->id_plan_estudio,
            'nombre' => $request->nombre,
            'num_modulo' => $request->num_modulo,
            'horas' => $request->horas,
            'creditos' => $request->creditos,
        ]);

        // Respuesta exitosa en formato JSON
        return response()->json([
            'success' => true,
            'message' => 'Módulo creado correctamente.',
        ]);
    } catch (\Exception $e) {
        // Respuesta de error en caso de excepciones
        return response()->json([
            'success' => false,
            'message' => 'Hubo un problema al crear el módulo: ' . $e->getMessage(),
        ]);
    }
}



    public function edit($id)
    {
        $modulo = ModuloFormativo::findOrFail($id);
        $planesEstudio = PlanEstudio::all();
        return view('modulo_formativos.edit', compact('modulo', 'planesEstudio'));
    }

    public function update(Request $request, $id)
    {
        // Validar los datos recibidos
        $request->validate([
            'id_plan_estudio' => 'required|exists:planes_estudio,id',
            'nombre' => 'required|string|max:100',
            'num_modulo' => 'required|integer',
            'horas' => 'required|integer|min:0',
            'creditos' => 'required|integer|min:0',
        ]);

        try {
            // Buscar el módulo y actualizarlo con campos específicos
            $modulo = ModuloFormativo::findOrFail($id);
            $modulo->update([
                'id_plan_estudio' => $request->id_plan_estudio,
                'nombre' => $request->nombre,
                'num_modulo' => $request->num_modulo,
                'horas' => $request->horas,
                'creditos' => $request->creditos,
            ]);

            return response()->json([
                'success' => true,
                'message' => 'Módulo actualizado correctamente.',
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Error al actualizar el módulo: ' . $e->getMessage(),
            ]);
        }
    }

    
    public function destroy($id)
    {
        // Buscar el módulo por ID
        $modulo = ModuloFormativo::findOrFail($id);

        // Eliminar el módulo
        $modulo->delete();

        // Retornar una respuesta JSON indicando éxito
        return response()->json([
            'success' => true,
            'message' => '¡Módulo eliminado correctamente!'
        ]);
    }

    public function filter(Request $request)
{
    // Obtener el ID del Plan de Estudio
    $planId = $request->get('id_plan_estudio');

    // Filtrar los módulos por Plan de Estudio
    if ($planId) {
        $modulos = ModuloFormativo::where('id_plan_estudio', $planId)->get();
    } else {
        // Si no se seleccionó un Plan de Estudio, mostrar todos los módulos
        $modulos = ModuloFormativo::all();
    }

    // Retornar la respuesta en formato JSON
    return response()->json([
        'modulos' => $modulos
    ]);
}


}
