<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Sesion extends Model
{
    protected $table = 'sesiones'; // nombre de la tabla en la BD

    protected $primaryKey = 'id_sesion'; // clave primaria

    protected $fillable = [
        'curso_id',
        'fecha',
        'fecha_fin',
        'nombre',
        'archivo',
        'fecha_creacion',
        'activo',
    ];

    public $timestamps = true;

    public function curso()
    {
        return $this->belongsTo(Curso::class, 'curso_id');
    }

    public function archivos()
    {
        return $this->hasMany(ArchivoCurso::class, 'sesion_id');
    }
}
