
<?php $__env->startSection('title'); ?> Inicio <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- this is breadcrumbs -->
<?php $__env->startComponent('components.breadcrumb'); ?>
<?php $__env->slot('li_1'); ?> Inicio <?php $__env->endSlot(); ?>
<?php $__env->slot('li_2'); ?> Panel Academico <?php $__env->endSlot(); ?>
<?php $__env->slot('title'); ?> Estudiantes <?php $__env->endSlot(); ?>
<?php echo $__env->renderComponent(); ?>

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                
                <div class="d-flex mb-3">
                    <div>
                        <a href="<?php echo e(route('estudiantes.create')); ?>" class="btn btn-de-primary btn-sm px-4 mt-0 mb-3">
                            <i class="fas fa-plus"></i> Nuevo Estudiante
                        </a>
                         <button type="button" class="btn btn-success btn-sm px-4 mt-0 mb-3 ms-2"
                                data-bs-toggle="modal"
                                data-bs-target="#modalImportarEstudiantes">
                            <i class="fas fa-file-excel"></i> Importación Masiva
                        </button>

                        
                    </div>
                </div>

                <div class="table-responsive">
                    <table id="tablaPostulantes" class="table table-striped mb-0 table-hover">
                        <thead class="thead-light">
                            <tr>
                                <th>#</th>
                                <th>Nombre Completo</th>
                                <th>DNI</th>
                                <th>Correo</th>
                                <th>Teléfono</th>
                                <th>Fecha de Nacimiento</th>
                                <th>Grado</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $postulantes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $postulante): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr id="fila-<?php echo e($postulante->id_postulante); ?>">
                                <td><?php echo e($postulante->id_postulante); ?></td>
                                <td><?php echo e($postulante->nombres); ?> <?php echo e($postulante->apellidos); ?></td>
                                <td><?php echo e($postulante->dni); ?></td>
                                <td><?php echo e($postulante->email); ?></td>
                                <td><?php echo e($postulante->telefono); ?></td>
                                <td><?php echo e($postulante->fecha_nacimiento); ?></td>
                                <td><?php echo e($postulante->grado); ?></td>
                                <td>
                                    <!-- VER -->
                                    <a href="<?php echo e(route('estudiantes.show', $postulante->id_postulante)); ?>"
                                    class="text-info me-2" title="Ver detalles">
                                        <i class="las la-eye font-18"></i>
                                    </a>

                                    <!-- EDITAR -->
                                    <a href="javascript:void(0);"
                                    class="btn-editar-postulante me-2"
                                    data-id="<?php echo e($postulante->id_postulante); ?>"
                                    data-nombres="<?php echo e($postulante->nombres); ?>"
                                    data-apellidos="<?php echo e($postulante->apellidos); ?>"
                                    data-dni="<?php echo e($postulante->dni); ?>"
                                    data-email="<?php echo e($postulante->email); ?>"
                                    data-telefono="<?php echo e($postulante->telefono); ?>"
                                    data-direccion="<?php echo e($postulante->direccion); ?>"
                                    title="Editar">
                                        <i class="las la-pen text-secondary font-18"></i>
                                    </a>

                                    <!-- ELIMINAR -->
                                    <a href="javascript:void(0);"
                                    class="text-danger btn-eliminar-postulante"
                                    data-id="<?php echo e($postulante->id_postulante); ?>">
                                        <i class="las la-trash-alt font-18"></i>
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
  

                </div>
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>

<!-- Modal de agregar -->
<!-- Modal para crear nuevo requisito -->

<div class="modal fade" id="modalImportarEstudiantes" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <form id="formImportarEstudiantes" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>

            <div class="modal-content">

                <div class="modal-header bg-success text-white">
                    <h5 class="modal-title">
                        <i class="fas fa-users"></i> Importación Masiva de Estudiantes
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">

                    <div class="row">

                        <!-- SUBIR ARCHIVO -->
                        <div class="col-md-6 mb-3">
                            <label class="fw-bold">Subir Archivo Excel</label>
                            <input type="file" name="archivo" class="form-control" required>
                            <small class="text-muted">Formatos permitidos: .xlsx, .xls</small>
                        </div>

                        <!-- INSTRUCCIONES -->
                        <div class="col-md-6 mb-3">
                            <label class="fw-bold">Instrucciones</label>
                            <ul class="small">
                                <li>Descarga la plantilla modelo.</li>
                                <li>Llena los campos: <strong>DNI, Nombres, Apellidos, Email, Teléfono</strong>.</li>
                                <li>Todos los estudiantes se registrarán con el grado <strong>Estudiante</strong>.</li>
                                <li>El usuario y contraseña será su DNI.</li>
                            </ul>

                            <a href="<?php echo e(asset('plantillas/plantilla_estudiantes.xlsx')); ?>"
                               class="btn btn-outline-primary btn-sm">
                                <i class="fas fa-download"></i> Descargar Plantilla
                            </a>
                        </div>

                    </div>

                </div>

                <div class="modal-footer">
                    <button type="submit" class="btn btn-success">
                        <i class="fas fa-upload"></i> Importar Excel
                    </button>
                </div>

            </div>

        </form>
    </div>
</div>




<!-- Modal Editar Postulante -->
<div class="modal fade" id="editModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Editar Postulante</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <form id="formEditarPostulante">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>

                <input type="hidden" id="edit_id">

                <div class="modal-body">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label>Nombres</label>
                            <input type="text" id="edit_nombres" class="form-control" required>
                        </div>

                        <div class="col-md-6">
                            <label>Apellidos</label>
                            <input type="text" id="edit_apellidos" class="form-control" required>
                        </div>

                        <div class="col-md-6">
                            <label>DNI</label>
                            <input type="text" id="edit_dni" class="form-control" required>
                        </div>

                        <div class="col-md-6">
                            <label>Email</label>
                            <input type="email" id="edit_email" class="form-control" required>
                        </div>

                        <div class="col-md-6">
                            <label>Teléfono</label>
                            <input type="text" id="edit_telefono" class="form-control">
                        </div>

                        <div class="col-md-6">
                            <label>Dirección</label>
                            <input type="text" id="edit_direccion" class="form-control">
                        </div>
                    </div>

                    <hr>
                    <h6 class="text-muted">Cambiar contraseña (opcional)</h6>

                    <div class="row g-3">
                        <div class="col-md-6">
                            <input type="password" id="edit_password" class="form-control" placeholder="Nueva contraseña">
                        </div>

                        <div class="col-md-6">
                            <input type="password" id="edit_password_confirmation" class="form-control" placeholder="Confirmar contraseña">
                        </div>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Guardar cambios</button>
                </div>
            </form>
        </div>
    </div>
</div>




<!--end row-->


<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    $(document).ready(function () {
        $("#tablaPostulantes").DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": false,
            "buttons": [
                {
                    extend: 'collection',
                    text: 'Opciones',
                    buttons: [
                        { extend: 'copy', text: 'Copiar' },
                        { extend: 'csv', text: 'CSV' },
                        { extend: 'excel', text: 'Excel', title: 'Periodos Académicos' },
                        { extend: 'pdf', text: 'PDF' },
                        { extend: 'print', text: 'Imprimir' }
                    ]
                },
                { extend: 'colvis', text: 'Visibilidad de Columna' }
            ],
            "paging": true,
            "searching": true,
            "info": true,
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ registros por página",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "first": "Primero",
                    "previous": "Anterior",
                    "next": "Siguiente",
                    "last": "Último"
                }
            }
        }).buttons().container().appendTo('#tablaPostulantes_wrapper .col-md-6:eq(0)');
    });
</script>




<script>
$(document).ready(function () {

    $('#formImportarEstudiantes').submit(function (e) {
        e.preventDefault();

        let formData = new FormData(this);

        Swal.fire({
            title: 'Importando...',
            text: 'Procesando archivo, por favor espere.',
            allowOutsideClick: false,
            didOpen: () => Swal.showLoading()
        });

        $.ajax({
            url: "<?php echo e(route('estudiantes.importar')); ?>",
            type: "POST",
            data: formData,
            contentType: false,
            processData: false,

            success: function (response) {
                Swal.close();

                Swal.fire({
                    icon: 'success',
                    title: 'Estudiantes importados',
                    text: response.message,
                    timer: 2000,
                    showConfirmButton: false
                });

                $('#modalImportarEstudiantes').modal('hide');

                setTimeout(() => location.reload(), 1200);
            },

            error: function (xhr) {
                Swal.close();

                if (xhr.status === 422) {
                    let msg = "";

                    if (xhr.responseJSON.errors) {
                        xhr.responseJSON.errors.forEach(e => msg += e + "<br>");
                    }

                    Swal.fire({
                        icon: 'error',
                        title: 'Errores en el archivo',
                        html: msg
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error inesperado',
                        text: xhr.responseJSON?.message ?? 'No se pudo procesar el archivo.'
                    });
                }
            }
        });

    });

});
</script>


<script>
    $(document).on('click', '.btn-editar-postulante', function () {

        $('#edit_id').val($(this).data('id'));
        $('#edit_nombres').val($(this).data('nombres'));
        $('#edit_apellidos').val($(this).data('apellidos'));
        $('#edit_dni').val($(this).data('dni'));
        $('#edit_email').val($(this).data('email'));
        $('#edit_telefono').val($(this).data('telefono'));
        $('#edit_direccion').val($(this).data('direccion'));

        $('#edit_password').val('');
        $('#edit_password_confirmation').val('');

        // 🔥 Abrir modal correctamente (Bootstrap 5)
        const modal = new bootstrap.Modal(document.getElementById('editModal'));
        modal.show();
    });

    $('#formEditarPostulante').on('submit', function (e) {
        e.preventDefault();

        let id = $('#edit_id').val();

        $.ajax({
            url: `/postulantess/${id}`,
            type: 'POST',
            data: {
                _token: $('meta[name="csrf-token"]').attr('content'),
                _method: 'PUT',
                nombres: $('#edit_nombres').val(),
                apellidos: $('#edit_apellidos').val(),
                dni: $('#edit_dni').val(),
                email: $('#edit_email').val(),
                telefono: $('#edit_telefono').val(),
                direccion: $('#edit_direccion').val(),
                password: $('#edit_password').val(),
                password_confirmation: $('#edit_password_confirmation').val()
            },
            success: function () {
                const modalEl = document.getElementById('editModal');
                bootstrap.Modal.getInstance(modalEl).hide();

                Swal.fire({
                    icon: 'success',
                    title: 'Actualizado',
                    text: 'Los datos fueron actualizados correctamente',
                    timer: 2000,
                    showConfirmButton: false
                }).then(() => location.reload());
            },
            error: function (xhr) {
                let mensaje = 'Ocurrió un error';

                if (xhr.responseJSON && xhr.responseJSON.errors) {
                    mensaje = '';
                    $.each(xhr.responseJSON.errors, function (key, value) {
                        mensaje += value[0] + '<br>';
                    });
                }

                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    html: mensaje
                });
            }
        });
    });
</script>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dedu/public_html/iestppiscobamba.dedu.pe/resources/views/postulantess/index.blade.php ENDPATH**/ ?>